﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;

public partial class Admin_NeiRong_HeBingLanMu : System.Web.UI.Page
{
    private 访问 访问;
    protected String 执行代码;
    protected String 栏目类型;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("合并栏目", "网站后台", "合并栏目", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            合并栏目();
        else
            初始化栏目();
    }

    private void 获取栏目(String 标题信息, out String 栏目类型, out int ID)
    {
        if (标题信息.StartsWith("w"))
        {
            栏目类型 = "文章";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("t"))
        {
            栏目类型 = "图片";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("r"))
        {
            栏目类型 = "软件";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("y"))
        {
            栏目类型 = "音乐";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("sa"))
        {
            栏目类型 = "商品";
            ID = Convert.ToInt32(标题信息.Substring(2));
        }
        else if (标题信息.StartsWith("s"))
        {
            栏目类型 = "视频";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else
        {
            栏目类型 = "小说";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
    }

    private void 合并栏目()
    {
        访问.验证权限("9");
        String 标题信息 = Request.QueryString["ti"];
        String 栏目类型;
        int ID;

        if (LanMuWeiZhi.SelectedValue==null||LanMuWeiZhi.SelectedValue=="")
            throw new Exception("请选择合并目标栏目");

        获取栏目(标题信息, out 栏目类型, out ID);
        this.栏目类型 = 栏目类型 + "栏目";

        SqlCommand 语句 = new SqlCommand("SELECT [是否拥有子栏目] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [栏目类型]=@栏目类型 AND [是否拥有子栏目]=@是否拥有子栏目 AND [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@是否拥有子栏目", SqlDbType.Bit).Value = false;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        SqlDataReader 读取 = 语句.ExecuteReader();
        bool 是否存在 = 读取.HasRows;
        读取.Close();

        if (!是否存在)
            throw new Exception("内容栏目必须没有子栏目");

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        语句.ExecuteNonQuery();
        switch (栏目类型)
        {
            case "文章":
                删除栏目文章(ID);
                break;
            case "图片":
                删除栏目图片(ID);
                break;
            case "软件":
                删除栏目软件(ID);
                break;
            case "音乐":
                删除栏目音乐(ID);
                break;
        }

        更新缓存数据 更新缓存 = new 更新缓存数据(this.Context, 访问.连接);
        更新缓存.内容栏目_更新();

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("合并栏目", 访问.用户["昵称"].ToString());

        执行代码 = "window.open('../DH_NeiRongGuanLi.aspx','ZuoDaoHang');" +
            "location.href='FenLeiNeiRongLieBiao.aspx?ID="+Convert.ToInt32(LanMuWeiZhi.SelectedValue)+"';";
    }

    private void 删除栏目文章(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[文件资源] FROM ["+程序.数据表前缀+"内容_文章_文章] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "文章");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除文章(Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除文章(String 文件资源, int ID)
    {
        if (文件资源 == null)
        {
            String[] 文件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
            for (int i = 0; i < 文件数组.Length; i++)
                if (File.Exists(Server.MapPath(文件数组[i])))
                    File.Delete(Server.MapPath(文件数组[i]));
        }

        File.Delete(Server.MapPath(程序.安装位置 + "Data/DT_WenZhang/" + (ID /500) + "/" + ID + ".txt"));

        SqlCommand 语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_评论] WHERE [内容类型]='文章' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_文章_文章] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目图片(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[文件资源] FROM ["+程序.数据表前缀+"内容_图片_图片] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "图片");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除图片(Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除图片(String 文件资源, int ID)
    {

        if (文件资源 != null)
        {
            String[] 文件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
            for (int i = 0; i < 文件数组.Length; i++)
                if (File.Exists(Server.MapPath(文件数组[i])))
                    File.Delete(Server.MapPath(文件数组[i]));
        }
        File.Delete(Server.MapPath(程序.安装位置 + "Data/DT_TuPian/" + (ID /500) + "/" + ID + ".Xml"));

        SqlCommand 语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_评论] WHERE [内容类型]='图片' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_图片_图片] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目软件(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[图片文件],[文件资源] FROM ["+程序.数据表前缀+"内容_软件_软件] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "软件");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除软件(Convert.ToString(数据.Tables[0].Rows[i]["图片文件"]),
                Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除软件(String 图片文件, String 文件资源, int ID)
    {

        String[] 图片数组 = 图片文件.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 图片数组.Length; i++)
            if (File.Exists(Server.MapPath(图片数组[i])))
                File.Delete(Server.MapPath(图片数组[i]));

        String[] 软件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 软件数组.Length; i++)
            if (File.Exists(Server.MapPath(软件数组[i])))
                File.Delete(Server.MapPath(软件数组[i]));

        File.Delete(Server.MapPath(程序.安装位置 + "Data/DT_RuanJian/" + (ID /500) + "/" + ID + ".Xml"));

        SqlCommand 语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_评论] WHERE [内容类型]='软件' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_软件_软件] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目音乐(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[文件资源] FROM ["+程序.数据表前缀+"内容_音乐_音乐] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "音乐");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除音乐(Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除音乐(String 文件资源, int ID)
    {

        String[] 文件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 文件数组.Length; i++)
            if (File.Exists(Server.MapPath(文件数组[i])))
                File.Delete(Server.MapPath(文件数组[i]));

        SqlCommand 语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_评论] WHERE [内容类型]='音乐' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM ["+程序.数据表前缀+"内容_音乐_音乐] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 初始化栏目()
    {
        String 标题信息 = Request.QueryString["ti"];
        String 栏目类型;
        int ID, 所属栏目;

        获取栏目(标题信息, out 栏目类型, out ID);
        this.栏目类型 = 栏目类型 + "栏目";

        SqlCommand 语句 = new SqlCommand("SELECT [所属栏目] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            所属栏目 = Convert.ToInt32(读取["所属栏目"]);
        else
        {
            读取.Close();
            throw new Exception("内容栏目不存在");
        }
        读取.Close();

        DataSet 数据 = new DataSet();
        语句 = new SqlCommand("SELECT [ID],[栏目名称],[所属栏目],[是否拥有子栏目] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]<>@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "内容栏目");

        生成列表(数据, 0, 1);
    }

    private void 生成列表(DataSet 数据, int 父栏目, int 深度)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属栏目"]) == 父栏目)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["栏目名称"]), Convert.ToString(行["ID"]));
                列表项.Attributes["style"] = Convert.ToBoolean(行["是否拥有子栏目"]) ? "" : "background:#eeeeee";
                LanMuWeiZhi.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值 + "|-";
    }
}
